using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///UI dialog allowing users to select supplies from inventory for association
		///</summary>

		#endregion


	public class DlgSelectSupply : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// Original Unit being modified - Needed to supply any exceptions with data
		/// </summary>
		private BOL.BloodUnit _originalUnit = null;

		/// <summary>
		/// BloodUnitModification class - need this data for any exceptions
		/// </summary>
		private BOL.BloodUnitModification _bumControl = null;

		/// <summary>
		/// Used to persist the list of selected items so they can be redisplayed after a search
		/// </summary>
		private System.Collections.Hashtable _selectedItems = new System.Collections.Hashtable();
		
		/// <summary>
		/// When a search is performed, we don't want the ItemCheck event of the listview to fire
		/// </summary>
		private bool _isSearching = false;

		private string _limitedSupplyText = string.Empty;

		private Common.SupplyType _limitingSupplyTypeId = Common.SupplyType.AllSupplies;

		#endregion

		#region Controls
		
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpResults;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ColumnHeader colLotNumber;
		private System.Windows.Forms.ColumnHeader colSupplyName;
		private System.Windows.Forms.GroupBox grpSearch;
		private System.Windows.Forms.Panel pnlSearchCriteria;
		private System.Windows.Forms.Panel pnlSerialNumber;
		private System.Windows.Forms.TextBox txtLotNumberSearchString;
		private System.Windows.Forms.Label lblLotNumberSearchString;
		private System.Windows.Forms.Splitter splitter2;
		private System.Windows.Forms.Panel pnlManufacturer;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbManufacturer;
		private System.Windows.Forms.Label lblManufacturerSearchString;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel pnlSupplyType;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbSupplyType;
		private System.Windows.Forms.Label lblSupplyType;
		private System.Windows.Forms.ColumnHeader colSupplySelect;
		private System.Windows.Forms.ColumnHeader colSupplyManufacturer;
		private System.Windows.Forms.ColumnHeader colExpires;
		private System.Windows.Forms.ListView lvSupplies;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private System.Windows.Forms.ColumnHeader colSupplyType;
		private System.ComponentModel.IContainer components = null;
		#endregion 

		#region Constructors/Destructors
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// DlgSelectSupply constructor, limits selection to a single supply of given supply type
		/// </summary>
		/// <param name="supplyTypeId">Supply type Id</param>
		/// <param name="allowMultiSelect">Allows more than one item to be selected</param>
		/// <param name="usedSupplies">Supplies already assigned to unit - if any</param>
		/// <param name="originalUnit">Needed for any exceptions generated</param>
		/// <param name="bumControl">Needed for any exceptions generated</param>
		public DlgSelectSupply(Common.SupplyType supplyTypeId, bool allowMultiSelect, ArrayList usedSupplies, BOL.BloodUnit originalUnit, BOL.BloodUnitModification bumControl)
		{
			InitializeComponent();

			this.EnableOkButton();

			//Save these fellas off
			this._originalUnit = originalUnit;
			this._bumControl = bumControl;
			//
			//
			if (this._bumControl.IsPool)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.DlgSelectSupply());
			}
			else if (this._bumControl.IsSplit)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC025.DlgSelectSupply());
			}
			else
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgSelectSupply());
			}
			//
			//Add our previously "selected" supplies to the hash table
			for(int ndx=0; ndx < usedSupplies.Count; ndx++)
			{
				BOL.Supply tmpSupply = (BOL.Supply)usedSupplies[ndx];

				//Empty guids are in splits - Original Containers
				if (tmpSupply.SupplyGuid != System.Guid.Empty)
					this._selectedItems.Add(tmpSupply.SupplyGuid, tmpSupply);
			}

			SetComponentProperties();
			
			this.lvSupplies.MultiSelect = allowMultiSelect;

			this._limitingSupplyTypeId = supplyTypeId;
			this.GetSupplies();
			this.PopulateComboBoxes();

			//PopulateComboBoxes sets this._limitedSupplyText
			this.Text = "VBECS - Select " + this._limitedSupplyText;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectSupply));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpResults = new System.Windows.Forms.GroupBox();
			this.lvSupplies = new System.Windows.Forms.ListView();
			this.colSupplySelect = new System.Windows.Forms.ColumnHeader();
			this.colLotNumber = new System.Windows.Forms.ColumnHeader();
			this.colSupplyName = new System.Windows.Forms.ColumnHeader();
			this.colSupplyType = new System.Windows.Forms.ColumnHeader();
			this.colSupplyManufacturer = new System.Windows.Forms.ColumnHeader();
			this.colExpires = new System.Windows.Forms.ColumnHeader();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpSearch = new System.Windows.Forms.GroupBox();
			this.pnlSearchCriteria = new System.Windows.Forms.Panel();
			this.pnlSerialNumber = new System.Windows.Forms.Panel();
			this.btnClear = new System.Windows.Forms.Button();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.txtLotNumberSearchString = new System.Windows.Forms.TextBox();
			this.lblLotNumberSearchString = new System.Windows.Forms.Label();
			this.splitter2 = new System.Windows.Forms.Splitter();
			this.pnlManufacturer = new System.Windows.Forms.Panel();
			this.cmbManufacturer = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblManufacturerSearchString = new System.Windows.Forms.Label();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlSupplyType = new System.Windows.Forms.Panel();
			this.cmbSupplyType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblSupplyType = new System.Windows.Forms.Label();
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.grpImage.SuspendLayout();
			this.grpResults.SuspendLayout();
			this.grpSearch.SuspendLayout();
			this.pnlSearchCriteria.SuspendLayout();
			this.pnlSerialNumber.SuspendLayout();
			this.pnlManufacturer.SuspendLayout();
			this.pnlSupplyType.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(712, 30);
			this.vbecsLogo1.TabIndex = 4;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 357);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(548, 348);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(48, 308);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 44);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpResults
			// 
			this.grpResults.AccessibleDescription = "Search Results";
			this.grpResults.AccessibleName = "Search Results";
			this.grpResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpResults.Controls.Add(this.lvSupplies);
			this.grpResults.Location = new System.Drawing.Point(56, 100);
			this.grpResults.Name = "grpResults";
			this.grpResults.Size = new System.Drawing.Size(652, 244);
			this.grpResults.TabIndex = 1;
			this.grpResults.TabStop = false;
			this.grpResults.Text = "Search Results";
			// 
			// lvSupplies
			// 
			this.lvSupplies.AccessibleDescription = "Supplies Information";
			this.lvSupplies.AccessibleName = "Supplies Information";
			this.lvSupplies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSupplies.CheckBoxes = true;
			this.lvSupplies.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.colSupplySelect,
																						 this.colLotNumber,
																						 this.colSupplyName,
																						 this.colSupplyType,
																						 this.colSupplyManufacturer,
																						 this.colExpires});
			this.lvSupplies.FullRowSelect = true;
			this.lvSupplies.Location = new System.Drawing.Point(8, 16);
			this.lvSupplies.MultiSelect = false;
			this.lvSupplies.Name = "lvSupplies";
			this.lvSupplies.Size = new System.Drawing.Size(638, 220);
			this.lvSupplies.TabIndex = 0;
			this.lvSupplies.View = System.Windows.Forms.View.Details;
			this.lvSupplies.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSupplies_ColumnClick);
			this.lvSupplies.SelectedIndexChanged += new System.EventHandler(this.lvSupplies_SelectedIndexChanged);
			this.lvSupplies.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSupplies_ItemCheck);
			// 
			// colSupplySelect
			// 
			this.colSupplySelect.Text = "";
			this.colSupplySelect.Width = 25;
			// 
			// colLotNumber
			// 
			this.colLotNumber.Text = "Lot Number";
			this.colLotNumber.Width = 85;
			// 
			// colSupplyName
			// 
			this.colSupplyName.Text = "Supply Name";
			this.colSupplyName.Width = 150;
			// 
			// colSupplyType
			// 
			this.colSupplyType.Text = "Supply Type";
			this.colSupplyType.Width = 120;
			// 
			// colSupplyManufacturer
			// 
			this.colSupplyManufacturer.Text = "Manufacturer";
			this.colSupplyManufacturer.Width = 150;
			// 
			// colExpires
			// 
			this.colExpires.Text = "Expires";
			this.colExpires.Width = 80;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(628, 348);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			// 
			// grpSearch
			// 
			this.grpSearch.AccessibleDescription = "Search Criteria";
			this.grpSearch.AccessibleName = "Search Criteria";
			this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearch.Controls.Add(this.pnlSearchCriteria);
			this.grpSearch.Location = new System.Drawing.Point(56, 36);
			this.grpSearch.Name = "grpSearch";
			this.grpSearch.Size = new System.Drawing.Size(652, 60);
			this.grpSearch.TabIndex = 0;
			this.grpSearch.TabStop = false;
			this.grpSearch.Text = "Search Criteria*";
			// 
			// pnlSearchCriteria
			// 
			this.pnlSearchCriteria.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlSearchCriteria.Controls.Add(this.pnlSerialNumber);
			this.pnlSearchCriteria.Controls.Add(this.splitter2);
			this.pnlSearchCriteria.Controls.Add(this.pnlManufacturer);
			this.pnlSearchCriteria.Controls.Add(this.splitter1);
			this.pnlSearchCriteria.Controls.Add(this.pnlSupplyType);
			this.pnlSearchCriteria.Location = new System.Drawing.Point(8, 12);
			this.pnlSearchCriteria.Name = "pnlSearchCriteria";
			this.pnlSearchCriteria.Size = new System.Drawing.Size(640, 44);
			this.pnlSearchCriteria.TabIndex = 37;
			this.pnlSearchCriteria.Resize += new System.EventHandler(this.pnlSearchCriteria_Resize);
			// 
			// pnlSerialNumber
			// 
			this.pnlSerialNumber.Controls.Add(this.btnClear);
			this.pnlSerialNumber.Controls.Add(this.btnSearch);
			this.pnlSerialNumber.Controls.Add(this.txtLotNumberSearchString);
			this.pnlSerialNumber.Controls.Add(this.lblLotNumberSearchString);
			this.pnlSerialNumber.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlSerialNumber.Location = new System.Drawing.Point(326, 0);
			this.pnlSerialNumber.Name = "pnlSerialNumber";
			this.pnlSerialNumber.Size = new System.Drawing.Size(314, 44);
			this.pnlSerialNumber.TabIndex = 4;
			// 
			// btnClear
			// 
			this.btnClear.Location = new System.Drawing.Point(232, 16);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 3;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// btnSearch
			// 
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = null;
			this.btnSearch.Location = new System.Drawing.Point(152, 16);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 2;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtLotNumberSearchString
			// 
			this.txtLotNumberSearchString.AccessibleDescription = "Lot Number";
			this.txtLotNumberSearchString.AccessibleName = "Lot Number";
			this.txtLotNumberSearchString.Location = new System.Drawing.Point(0, 22);
			this.txtLotNumberSearchString.MaxLength = 50;
			this.txtLotNumberSearchString.Name = "txtLotNumberSearchString";
			this.txtLotNumberSearchString.Size = new System.Drawing.Size(144, 20);
			this.txtLotNumberSearchString.TabIndex = 1;
			this.txtLotNumberSearchString.Text = "";
			// 
			// lblLotNumberSearchString
			// 
			this.lblLotNumberSearchString.Location = new System.Drawing.Point(0, 4);
			this.lblLotNumberSearchString.Name = "lblLotNumberSearchString";
			this.lblLotNumberSearchString.Size = new System.Drawing.Size(144, 20);
			this.lblLotNumberSearchString.TabIndex = 0;
			this.lblLotNumberSearchString.Text = "Lot Number";
			this.lblLotNumberSearchString.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// splitter2
			// 
			this.splitter2.Location = new System.Drawing.Point(323, 0);
			this.splitter2.Name = "splitter2";
			this.splitter2.Size = new System.Drawing.Size(3, 44);
			this.splitter2.TabIndex = 3;
			this.splitter2.TabStop = false;
			// 
			// pnlManufacturer
			// 
			this.pnlManufacturer.Controls.Add(this.cmbManufacturer);
			this.pnlManufacturer.Controls.Add(this.lblManufacturerSearchString);
			this.pnlManufacturer.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlManufacturer.Location = new System.Drawing.Point(163, 0);
			this.pnlManufacturer.Name = "pnlManufacturer";
			this.pnlManufacturer.Size = new System.Drawing.Size(160, 44);
			this.pnlManufacturer.TabIndex = 2;
			// 
			// cmbManufacturer
			// 
			this.cmbManufacturer.AccessibleDescription = "Manufacturer";
			this.cmbManufacturer.AccessibleName = "Manufacturer";
			this.cmbManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbManufacturer.Interval = 100;
			this.cmbManufacturer.Location = new System.Drawing.Point(0, 20);
			this.cmbManufacturer.Name = "cmbManufacturer";
			this.cmbManufacturer.Size = new System.Drawing.Size(156, 22);
			this.cmbManufacturer.TabIndex = 1;
			// 
			// lblManufacturerSearchString
			// 
			this.lblManufacturerSearchString.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblManufacturerSearchString.Location = new System.Drawing.Point(0, 4);
			this.lblManufacturerSearchString.Name = "lblManufacturerSearchString";
			this.lblManufacturerSearchString.Size = new System.Drawing.Size(156, 20);
			this.lblManufacturerSearchString.TabIndex = 0;
			this.lblManufacturerSearchString.Text = "Manufacturer";
			this.lblManufacturerSearchString.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(160, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 44);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// pnlSupplyType
			// 
			this.pnlSupplyType.Controls.Add(this.cmbSupplyType);
			this.pnlSupplyType.Controls.Add(this.lblSupplyType);
			this.pnlSupplyType.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlSupplyType.Location = new System.Drawing.Point(0, 0);
			this.pnlSupplyType.Name = "pnlSupplyType";
			this.pnlSupplyType.Size = new System.Drawing.Size(160, 44);
			this.pnlSupplyType.TabIndex = 0;
			// 
			// cmbSupplyType
			// 
			this.cmbSupplyType.AccessibleDescription = "Supply Type";
			this.cmbSupplyType.AccessibleName = "Supply Type";
			this.cmbSupplyType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbSupplyType.Interval = 100;
			this.cmbSupplyType.Location = new System.Drawing.Point(0, 20);
			this.cmbSupplyType.Name = "cmbSupplyType";
			this.cmbSupplyType.Size = new System.Drawing.Size(156, 22);
			this.cmbSupplyType.TabIndex = 1;
			// 
			// lblSupplyType
			// 
			this.lblSupplyType.Location = new System.Drawing.Point(0, 4);
			this.lblSupplyType.Name = "lblSupplyType";
			this.lblSupplyType.Size = new System.Drawing.Size(68, 20);
			this.lblSupplyType.TabIndex = 0;
			this.lblSupplyType.Text = "Supply Type";
			this.lblSupplyType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// DlgSelectSupply
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(712, 373);
			this.Controls.Add(this.grpSearch);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpResults);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(720, 400);
			this.Name = "DlgSelectSupply";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Supplies";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSelectSupply_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpResults, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpSearch, 0);
			this.grpImage.ResumeLayout(false);
			this.grpResults.ResumeLayout(false);
			this.grpSearch.ResumeLayout(false);
			this.pnlSearchCriteria.ResumeLayout(false);
			this.pnlSerialNumber.ResumeLayout(false);
			this.pnlManufacturer.ResumeLayout(false);
			this.pnlSupplyType.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties
		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Gets ArrayList of selected supplies
		/// </summary>
		public System.Collections.ArrayList SelectedSupplyList
		{
			get
			{
				System.Collections.ArrayList supplyList = new System.Collections.ArrayList();

				foreach(ListViewItem lvi in this.lvSupplies.CheckedItems)
				{
					BOL.Supply supply = (BOL.Supply)lvi.Tag;
					supplyList.Add(supply);
				}
				return supplyList;
			}
		}

		#endregion

		#region Methods/Functions

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Select Supplies";
			//
			this.cmbManufacturer.Interval = 100;
			this.cmbSupplyType.Interval = 100;

			this.btnSearch.Text = "&Search";
			this.btnSearch.SetToolTip(Common.StrRes.Tooltips.Common.SearchFor().ResString);
			this.ttToolTip.SetToolTip(this.btnClear, Common.StrRes.Tooltips.Common.ClearEntries().ResString);

		}
		

		/// <summary>
		/// Enables the OK button and sets a tooltip if needed
		/// </summary>
		private void EnableOkButton()
		{
			this.btnOK.EnabledButton = (this._selectedItems.Count > 0);

			if( this.btnOK.EnabledButton)
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			else
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
		}

		/// <summary>
		/// Fills the comboboxes with values retrieved from the database
		/// </summary>
		private void PopulateComboBoxes()
		{
			System.Collections.ArrayList supplyDetails = BOL.Supply.GetSupplyDetails();
			System.Collections.Hashtable supplyTypes = (System.Collections.Hashtable)supplyDetails[0];
			System.Collections.ArrayList manufacturers = (System.Collections.ArrayList)supplyDetails[1];

			//Load the SupplyTypes
			IDictionaryEnumerator typeEnum = supplyTypes.GetEnumerator();
			this.cmbSupplyType.Items.Clear();
			while(typeEnum.MoveNext())
			{
				this.cmbSupplyType.Items.Add(typeEnum.Value.ToString());
				
				//Save off the text value of the limited type to pop in the combobox
				if ((int)typeEnum.Key == (int)this._limitingSupplyTypeId)
					this._limitedSupplyText = typeEnum.Value.ToString();

			}

			//Load the manufacturers
			this.cmbManufacturer.Items.Clear();
			for(int ndx=0; ndx < manufacturers.Count; ndx++)
			{
				this.cmbManufacturer.Items.Add(manufacturers[ndx].ToString());
			}

			//Set/Disable the combobox if we're limiting the search
			if (this._limitingSupplyTypeId != Common.SupplyType.AllSupplies)
			{
				this.cmbSupplyType.Text = this._limitedSupplyText;
				this.cmbSupplyType.Enabled = false;
			}

			this.cmbSupplyType.SelectionLength = 0;
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to load supply items into UI for selection
		/// </summary>
		/// <param name="filterResults">blerf</param>
		/// <param name="supplyList">ArrayList of supply guids</param>
		private void LoadSupplies(bool filterResults, System.Collections.ArrayList supplyList)
		{
			this.lvSupplies.Items.Clear();

			//Build the supply list before we go through and check if we need to pre-check anything
			for(int ndx=0; ndx < supplyList.Count; ndx++)
			{
				BOL.Supply supply = (BOL.Supply)supplyList[ndx];

				bool checkItem = this._selectedItems.ContainsKey(supply.SupplyGuid);

				//If they already have it selected, let it go, otherwise, skip it
				if (!checkItem && !supply.SatisfactoryIndicator)
				{}	//DoNothing, we want to keep processing the for loop
				else
					this.AddSupplyToListview(supply, checkItem);
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvSupplies);
		}

		/// <summary>
		/// Adds a supply row to the lvSupplies control
		/// </summary>
		/// <param name="supplyObj"></param>
		/// <param name="checkItem"></param>
		private void AddSupplyToListview(BOL.Supply supplyObj, bool checkItem)
		{
			ListViewItem lvi = new ListViewItem();

			lvi.Checked = checkItem;				
			lvi.Tag = supplyObj;

			lvi.SubItems.Add(supplyObj.LotNumber);
			lvi.SubItems.Add(supplyObj.SupplyName);
			lvi.SubItems.Add(supplyObj.SupplyTypeText);
			lvi.SubItems.Add(supplyObj.ManufacturerName);
			lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(supplyObj.LotExpirationDate));
				
			this.lvSupplies.Items.Add(lvi);            
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to get list of matching supplies from database and display in UI
		/// </summary>
		private void GetSupplies()
		{
			System.Collections.ArrayList supplyList = null;

			if (this._limitingSupplyTypeId == Common.SupplyType.AllSupplies)
			{
				supplyList = BOL.Supply.GetSupplyListSansContainerSCD(false);
			}
			else
			{
				 supplyList = BOL.Supply.GetSupplyList(this._limitingSupplyTypeId,false, string.Empty);
			}

			this.LoadSupplies(false, supplyList);
		}

		#endregion

		#region Events/Event Handlers

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Search criteria panel resize event handler, aligns UI controls evenly
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void pnlSearchCriteria_Resize(object sender, System.EventArgs e)
		{
			this.pnlSupplyType.Width = (int)((this.pnlSearchCriteria.Width -6)/3);
			this.pnlManufacturer.Width = (int)((this.pnlSearchCriteria.Width -6)/3);

		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, closes dialog with OK result
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// List view item check event handler, only permits selection of one supply if supply type is fixed
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Item check event args</param>
		private void lvSupplies_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (!this._isSearching)
			{
				BOL.Supply tmpSupply = (BOL.Supply)this.lvSupplies.Items[e.Index].Tag;

				if (e.NewValue == CheckState.Checked)
				{
					//If supply type is fixed, only one supply may be checked
					if (!this.cmbSupplyType.Enabled)
					{
						foreach(ListViewItem lvi in this.lvSupplies.CheckedItems)
						{
							lvi.Checked = false;
						}
					}
					//If they're checkin an item that doesn't already exists, add it
					if (!this._selectedItems.ContainsKey(tmpSupply.SupplyGuid))
					{
						//BR_26.46 - If the supply is expired, prompt for reason and create exception
						if (tmpSupply.LotExpirationDate < this._bumControl.ModificationDateTime)
						{
							//TODO: Lohse: Test Timeout on this line
							DialogResult keepSupply = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC026.OverrideExpiredSupply(tmpSupply.ManufacturerName, tmpSupply.LotNumber, Common.VBECSDateTime.FormatDateTimeString(tmpSupply.LotExpirationDate)));

							if (keepSupply == DialogResult.Yes)
							{
								DlgOverrideComment dlgComment = new DlgOverrideComment("Expired Supply Override", "The supply has expired.  You have to enter a comment in order to proceed.", "RS");

								dlgComment.ShowDialogFromLockedParent(this,false);
                                if (dlgComment.DialogResult == DialogResult.Abort) return;

                                if (dlgComment.DialogResult == DialogResult.OK)
								{
									BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_Supply_UnitModification, dlgComment.Comment, Common.LogonUser.LogonUserName);
									exRep.GenerateExceptionUnitModification(this._originalUnit, this._bumControl, DateTime.MinValue, tmpSupply);
									tmpSupply.LotException = exRep;
									this._selectedItems.Add(tmpSupply.SupplyGuid, tmpSupply);
								}
								else	//Didn't enter a valid override comment
								{
									e.NewValue = e.CurrentValue;
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectDifferentSupply());
								}
							}
							else
								e.NewValue = e.CurrentValue;
						}
						else	//Not Expired
							this._selectedItems.Add(tmpSupply.SupplyGuid, tmpSupply);
					}
				}
				else
				{
					//If they're unchecking an item that's already been selected uncheck it
					if (this._selectedItems.ContainsKey(tmpSupply.SupplyGuid))
						this._selectedItems.Remove(tmpSupply.SupplyGuid);
				}
			}

			this.EnableOkButton();
		}

		/// <summary>
		/// Sorts the supply grid based on the column clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSupplies_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			//lvSupplies.Column 5 == Supply Expiration Date
			if (e.Column == 5)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSupplies.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSupplies.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}


		/// <summary>
		/// Resets the supply search criteria
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			//Reset the supply type only if they're allowed to be selecting from it.
			if (this._limitingSupplyTypeId == Common.SupplyType.AllSupplies)
			{
				this.cmbSupplyType.SelectedIndex = -1;
				this.cmbSupplyType.Text = string.Empty;
			}	
			this.cmbManufacturer.SelectedIndex = -1;
			this.cmbManufacturer.Text = string.Empty;
			this.txtLotNumberSearchString.Text = string.Empty;
		}

		/// <summary>
		/// Filters the available supplies based on the search criteria
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{

			this._isSearching = true;
			bool noResultsFound = true;

			//Clear the listview out first
			this.lvSupplies.Items.Clear();

			System.Collections.Hashtable newResultSet = new System.Collections.Hashtable();

			//Populate with the existing stuff first
			IDictionaryEnumerator iter1 = this._selectedItems.GetEnumerator();
			while (iter1.MoveNext())
			{
				BOL.Supply tmpSupply = (BOL.Supply)iter1.Value;
				AddSupplyToListview(tmpSupply, true);
			}

			//If they're looking for something in particular, let them see it
			bool includeAll = (this.txtLotNumberSearchString.Text.Trim() != string.Empty);

			System.Collections.ArrayList supplyList = null;
			//Grab a new set of supplies, just in case they've added one
			if (this._limitingSupplyTypeId == Common.SupplyType.AllSupplies)
			{
				 supplyList = BOL.Supply.GetSupplyListSansContainerSCD(includeAll);
			}
			else
			{
				supplyList = BOL.Supply.GetSupplyList(this._limitingSupplyTypeId, includeAll, string.Empty);
			}

			for(int ndx=0; ndx < supplyList.Count; ndx++)
			{
				bool manCheck = true;
				bool typeCheck = true;
				bool lotCheck = true;
				bool alreadyExists = false;
				BOL.Supply objTest = (BOL.Supply)supplyList[ndx];

				//If the items already been selected, we don't want to re-add it to the grid
				if (this._selectedItems.Contains(objTest.SupplyGuid))
					alreadyExists = true;

				//If they entered a manufacturer, check it
				if (this.cmbManufacturer.Text != string.Empty)
				{
					if (objTest.ManufacturerName != this.cmbManufacturer.Text)
						manCheck = false;
				}

				//If they entered a supply type, check it
				if (this.cmbSupplyType.Text != string.Empty)
				{
					if (objTest.SupplyTypeText != this.cmbSupplyType.Text)
						typeCheck = false;
				}
				
				//If they've enetered a lotnumber to search on, check it
				if (this.txtLotNumberSearchString.Text.Length > 0)
				{
					if (objTest.LotNumber != this.txtLotNumberSearchString.Text)
						lotCheck = false;
					else
					{
						//BR_26.45 - Don't let the user try to pick an expired supply
						//Hopefully this will only occur when they enter a specific lotnumber - per BR
						if (!alreadyExists && !objTest.SatisfactoryIndicator)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR45UnsatisfactorySupply());
							lotCheck = false;
							break;
						}
					}	
				}

				if (manCheck && typeCheck && lotCheck && !alreadyExists)
				{
					this.AddSupplyToListview(objTest, false);
					noResultsFound = false;
				}
			}
			this._isSearching = false;

			if (noResultsFound)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC020.NoMatchingEntries());
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectSupply_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.btnOK.GetToolTip() );
			}
		}

		#endregion

		private void lvSupplies_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvSupplies);
		}
	}
}

